/* Copyright (c) 2010-2020 openjournaltheme.com 
    Copyright (c) 2010-2020 openjournaltheme team
    Read this term of use of this theme here : https://openjournaltheme.com/term-of-conditions/
    Modify, redistribute or make commercial copy of this part or whole of this code is prohibited without written permission from openjournaltheme.com 
*/
var isRtl = (document.body.classList.contains('rtl')) ? true : false;

$(document).ready(function () {

    setUpHomePageSlider();
    setUpHomeSlideParallax();

    moveCurrentIssueToTab();
    createAnnoucementSlider();

    // Make compatible with JATS parser 
    //jats parser result right menu, so the menu would be position fixed on the right side
    if ($('.intraarticle-menu').length) {

        let jatsMenu = $('.intraarticle-menu');

        var distance = jatsMenu.offset().top,
            $window = $(window);

        $window.scroll(function () {
            if ($window.scrollTop() >= distance) {
                jatsMenu.css('position', 'fixed');
                jatsMenu.css('width', '18.5%');
                jatsMenu.css('top', '0');
            } else {
                jatsMenu.css('position', 'static');
                jatsMenu.css('width', '100%');
            }
        });
    }

    $(".navbar-toggle").on("click", function () {
        $('nav#nav-menu').toggle();
    });

    // End make JATS parser menu compability


    //https://stackoverflow.com/questions/3898130/check-if-a-user-has-scrolled-to-the-bottom
    $(window).scroll(function () {
        if ($(window).scrollTop() + $(window).height() > $(document).height() - 150) {
            $('.intraarticle-menu').hide();
            console.log('hide toc');
        } else {
            $('.intraarticle-menu').fadeIn();
        }
    });


});

function isEmpty(el) {
    return !$.trim(el.html())
}


var isMobile = window.matchMedia("only screen and (max-width: 760px)").matches;
var isTablet = window.matchMedia("only screen and (min-width: 768px)").matches;


function setUpHomePageSlider() {

    let module_homepage_slide = ($('#customblock-homepage_slide').length) ? $('#customblock-homepage_slide') : $('#customblock-HomepageSlide');
    module_homepage_slide = (module_homepage_slide.length > 0) ? module_homepage_slide : ($('#customblock-homepage-slide').length > 0 ? $('#customblock-homepage-slide') : $('#customblock-homepageslide'));
    
    if (module_homepage_slide.length == 0)
        return;

    console.log('Header slide activated');

    let header_section = $('.header_section');
    header_section.html('<div class="slide_container container"><div class="header_slider col-md-12"></div></div>');
    let home_page_slider = $('.header_slider');

    module_homepage_slide.find('img').each(function (index) {
        let link = $(this).parent('a');
        let content = (link.length) ? link : this;
        let description = $(this).parent('p').next();
        home_page_slider.append(content);

        if (!description.find('img').length) {
            //home_page_slider.append(description);
        }
        $(this).parent('p').remove();

    });


    $('.journal_index').css('background', 'none');
    $(module_homepage_slide).remove()

    $('.header_slider').slick({
        dots: true,
        infinite: true,
        slidesToShow: 1,
        slidesToScroll: 1,
        autoplay: true,
        autoplaySpeed: 3000,
        rtl: isRtl,

    });

}



function setUpHomeSlideParallax() {

    let module_homepage_slide_parallax = ($('#customblock-homepage_slide_parallax').length) ? $('#customblock-homepage_slide_parallax') : $('#customblock-HomepageSlideParallax');
    module_homepage_slide_parallax = (module_homepage_slide_parallax.length > 0) ? module_homepage_slide_parallax : $('#customblock-homepage-slide-parallax');
    module_homepage_slide_parallax = (module_homepage_slide_parallax.length > 0) ? module_homepage_slide_parallax : $('#customblock-homepageslideparallax');

    
    if (module_homepage_slide_parallax.length == 0)
        return;

    
    console.log('Header slide parallax activated');

    let content = `<div class="container">
                    <div class="swiper-container col-md-12">
                        <div class="parallax-bg" data-swiper-parallax="-23%"></div>
                        <div class="swiper-wrapper">        
                        </div>
                        <!-- Add Pagination -->
                        <div class="swiper-pagination swiper-pagination-white"></div>
                        <!-- Add Navigation -->
                        <div class="swiper-button-prev swiper-button-white"></div>
                        <div class="swiper-button-next swiper-button-white"></div>
                   </div>
                   </div>`;

    let slide_content = `<div class="swiper-slide">
        <div class="title" data-swiper-parallax="-300">Title</div>
            <div class="subtitle" data-swiper-parallax="-200">Subtitle</div>
            <div class="text" data-swiper-parallax="-100">
            <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam dictum mattis velit, sit amet faucibus felis iaculis nec. Nulla laoreet justo vitae porttitor porttitor. Suspendisse in sem justo. Integer laoreet magna nec elit suscipit, ac laoreet nibh euismod. Aliquam hendrerit lorem at elit facilisis rutrum. Ut at ullamcorper velit. Nulla ligula nisi, imperdiet ut lacinia nec, tincidunt ut libero. Aenean feugiat non eros quis feugiat.</p>
            </div>
        </div> `;


    let header_section = $('.header_section');
    header_section.html(content);
    let container = $('.swiper-container');

    let img_bg = module_homepage_slide_parallax.find('img').attr('src');
    container.find('.parallax-bg').attr('style', 'background-image:url(' + img_bg + ')');


    //header_text_slide
    module_homepage_slide_parallax.find('.header_text_slide').each(function (index) {

        let new_text_slide = $(this);
        new_text_slide.removeAttr('style');
        new_text_slide.addClass('swiper-slide');
        new_text_slide.find('.title').attr('data-swiper-parallax', '-300');
        new_text_slide.find('.subtitle').attr('data-swiper-parallax', '-200');
        new_text_slide.find('.text').attr('data-swiper-parallax', '-100');

        new_text_slide.find('.title').removeAttr('style');
        new_text_slide.find('.subtitle').removeAttr('style');

        container.find('.swiper-wrapper').append(new_text_slide);

    });



    // container.append(slide_content);


    var swiper = new Swiper('.swiper-container', {
        speed: 600,
        parallax: true,
        autoplay: {
            delay: 4500,
            disableOnInteraction: false,
        },
        pagination: {
            el: '.swiper-pagination',
            clickable: true,
        },
        navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev',
        },
    });

}

function moveCurrentIssueToTab() {
    let currentIssue = $('section.current_issue');
    let tabCurrentIssue = $('#current_issue');
    tabCurrentIssue.html(currentIssue);
}

function createAnnoucementSlider() {

    let annoucement = $('.cmp_announcements').find('.media-list');
    
    if(!annoucement.length) return;
    if(annoucement.find('article').length == 1) return;

    $(annoucement).slick({
        adaptiveHeight:true,
        infinite: true,
        slidesToShow: 1,
        slidesToScroll: 1,
        dots: true,
        infinite: true,
        speed: 500,
        fade: true,
        cssEase: 'linear',
        autoplay: true,
        rtl: isRtl
    });
}