<?php
/**
 * @defgroup plugins_themes_bootstrap3 Theme plugin for base Bootstrap 3 theme
 */

/**
 * @file plugins/themes/default/index.php
 *
 * Copyright (c) 2014-2017 Simon Fraser University Library
 * Copyright (c) 2003-2017 John Willinsky
 * Distributed under the GNU GPL v2. For full terms see the file docs/COPYING.
 *
 * Modified by openjournaltheme.com
 * contact : openjournaltheme@gmail.com
 *
 * @ingroup plugins_themes_default
 * @brief Wrapper for default theme plugin.
 *
 */

$versionDao    = DAORegistry::getDAO('VersionDAO')->getCurrentVersion()->_data;

$versionNumber        = $versionDao['major'] . $versionDao['minor'];

switch ($versionNumber) {
  case '33':
    require_once 'version/AcademicProThemeExtended33.inc.php';
    return new AcademicProThemeExtended33();
    break;
  default:
    require_once 'version/AcademicProThemeExtended32.inc.php';
    return new AcademicProThemeExtended32();
    break;
}
