{**
 * templates/frontend/objects/issue_summary.tpl
 *
  * Copyright (c) 2010-2020 openjournaltheme.com 
 * Copyright (c) 2010-2020 openjournaltheme team
 * Read this term of use of this theme here : https://openjournaltheme.com/term-of-conditions
 *
 * @brief View of an Issue which displays a summary for use in lists
 *
 * @uses $issue Issue The issue
 *}
<div class="issue-summary media">

	{* Retrieve separate entries for $issueTitle and $issueSeries *}
	{assign var=issueTitle value=$issue->getLocalizedTitle()}
	{assign var=issueSeries value=$issue->getIssueSeries()}
	{assign var=issueDescription value=$issue->getLocalizedDescription()}
	{assign var=issueCover value=$issue->getLocalizedCoverImageUrl()}

	{* Show cover image and use cover description *}
	{if $issueCover}
		<div class="col-md-3 col-xs-12">
			<a class="cover" href="{url op="view" path=$issue->getBestIssueId($currentJournal)}">
				<img class="media-object" src="{$issue->getLocalizedCoverImageUrl()}" style="width: 150px" >
			</a>
		</div>
	{/if}


	<div class="{if $issueCover} col-md-9 {else} col-md-12{/if} col-xs-12">
		<h2 class="media-heading">
			{if $issueTitle}
				<div class="series lead"  style="margin-top: 8px">
					{$issueSeries|escape|replace:'Vol':'Vol.'|replace:' No':', No'}
				</div>
			{/if}

			<a class="title" href="{url op="view" path=$issue->getBestIssueId($currentJournal)}">
				{if $issueTitle}
					{$issueTitle|escape}
				{else}
					{$issueSeries|escape}
				{/if}
			</a>
			
		</h2>
		<div class="description" style="margin-top: -12px">
			{$issueDescription|strip_unsafe_html|nl2br}

			{* Published date *}
			{if $issue->getDatePublished()}
				<p class="date_published">
					<strong>
						{translate key="submissions.published"}:
					</strong>
					{if ($journalVersion >= '33')}
						{$issue->getDatePublished()|date_format:$dateFormatLong}
					{else}
						{$issue->getDatePublished()|date_format}
					{/if}
				</p>
			{/if}

			
		</div>
	</div>
</div><!-- .issue-summary -->
