{**
 * templates/frontend/objects/article_details.tpl
 *
  * Copyright (c) 2010-2020 openjournaltheme.com 
 * Copyright (c) 2010-2020 openjournaltheme team
 * Read this term of use of this theme here : https://openjournaltheme.com/term-of-conditions
 *
 * @brief View of an Article which displays all details about the article.
 *  Expected to be primary object on the page.
 *
 * @uses $article Article This article
 * @uses $issue Issue The issue this article is assigned to
 * @uses $section Section The journal section this article is assigned to
 * @uses $keywords array List of keywords assigned to this article
 * @uses $citationFactory @todo
 * @uses $pubIdPlugins @todo
 *}


<article class="article-details">
	<header>
		<h1 class="page-header">

			{$article->getLocalizedTitle()|escape}
			{if $article->getLocalizedSubtitle()}
				<small>
					{$article->getLocalizedSubtitle()|escape}
					{if $section} <span class="pull-right">{translate key="section.section"}
						{$section->getLocalizedTitle()|escape}</span> {/if}
				</small>
			{/if}


		</h1>
	</header>

	<div class="row">


		<section class="article-sidebar col-md-4">



			{* Screen-reader heading for easier navigation jumps *}
			<h2 class="sr-only">{translate key="plugins.themes.academic_pro.article.sidebar"}</h2>

			{* Article/Issue cover image *}
			{if $article->getLocalizedCoverImage() || $issue->getLocalizedCoverImage()}
				<div class="cover-image">
					{if $article->getLocalizedCoverImage()}
						<img class="img-responsive" src="{$article->getLocalizedCoverImageUrl()|escape}"
							{if $article->getLocalizedCoverImageAltText()} alt="{$article->getLocalizedCoverImageAltText()|escape}" {/if}>
					{else}
						<a href="{url page="issue" op="view" path=$issue->getBestIssueId()}">
							<img class="img-responsive" src="{$issue->getLocalizedCoverImageUrl()|escape}"
								{if $issue->getLocalizedCoverImageAltText()} alt="{$issue->getLocalizedCoverImageAltText()|escape}" {/if}>
						</a>
					{/if}
				</div>
			{/if}





			<div class="list-group">

				{* Published date *}
				{if $article->getDatePublished() && $articleTrackingDate != 'no'}
					<div class="row date-list">

						<div class="col-md-12 detail">
							{if ($journalVersion >= '33')}
								<strong>{translate key="submissions.submitted"}</strong>
								<div class="date">{$article->getDateSubmitted()|date_format:$dateFormatLong}</div>
							</div>

							{if $acceptanceDate}
								<div class="col-md-12 detail">
									<strong>{translate key="submissions.accepted"}</strong>
									<div class="date">{$acceptanceDate|date_format:$dateFormatLong}</div>
								</div>
							{/if}

							<div class="col-md-12 detail">
								<strong>{translate key="submissions.published"}</strong>
								<div class="date">{$article->getDatePublished()|date_format:$dateFormatLong}</div>
							{else}
								<strong>{translate key="submissions.submitted"}</strong>
								<div class="date">{$article->getDateSubmitted()|date_format}</div>
							</div>

							{if $acceptanceDate}
								<div class="col-md-12 detail">
									<strong>{translate key="submissions.accepted"}</strong>
									<div class="date">{$acceptanceDate|date_format}</div>
								</div>
							{/if}

							<div class="col-md-12 detail">
								<strong>{translate key="submissions.published"}</strong>
								<div class="date">{$article->getDatePublished()|date_format}</div>
							{/if}
						</div>





					</div>
				{/if}

				{* DOI (requires plugin) *}
				{foreach from=$pubIdPlugins item=pubIdPlugin}
					{if $pubIdPlugin->getPubIdType() != 'doi'}
						{continue}
					{/if}
					{if $issue->getPublished()}
						{assign var=pubId value=$article->getStoredPubId($pubIdPlugin->getPubIdType())}
					{else}
						{assign var=pubId value=$pubIdPlugin->getPubId($article)}{* Preview pubId *}
					{/if}
					{if $pubId}
						{assign var="doiUrl" value=$pubIdPlugin->getResolvingURL($currentJournal->getId(), $pubId)|escape}
						<div class="list-group-item doi box-shadow">
							{* <strong>{translate key="plugins.pubIds.doi.readerDisplayName"}</strong> *}
							<span class="doi_logo"> </span>
							<a class="doi_link" href="{$doiUrl}">
								{$doiUrl}
							</a>
						</div>
					{/if}
				{/foreach}
			</div>


			{* Galleys *}
			<div class="panel panel-default galley_list">
				<div class="panel-heading">
					<i class="fa fa-download"> </i> Download
				</div>
				<div class="panel-body">
					{* Article Galleys *}
					{if $primaryGalleys || $supplementaryGalleys}
						<div class="download">
							{if $primaryGalleys}
								{foreach from=$primaryGalleys item=galley}
									{include file="frontend/objects/galley_link.tpl" parent=$article purchaseFee=$currentJournal->getSetting('purchaseArticleFee') purchaseCurrency=$currentJournal->getSetting('currency')}
								{/foreach}
							{/if}
							{if $supplementaryGalleys}
								{foreach from=$supplementaryGalleys item=galley}
									{include file="frontend/objects/galley_link.tpl" parent=$article isSupplementary="1"}
								{/foreach}
							{/if}
						</div>
					{/if}
				</div>
			</div>

			{* Stat *}
			{if $enableStatistic != 'no'}
				<div class="panel panel-default galley_list">
					<div class="panel-heading">
						<i class="fa fa-bar-chart"> </i> Statistic
					</div>
					<div class="panel-body">
						<div class=""> <span class="article_counter_read"> </span> Read Counter : <b>{$article->getViews()} </b> <span
								class="pull-right">Download : <b> {$galley->getViews()} </b> </span></div>
						{call_hook name="Templates::Article::Main"}
					</div>
				</div>
			{/if}






		</section><!-- .article-sidebar -->

		<div class="col-md-8">
			<section class="article-main">

				{* Issue *}
				<div class="issue_detail">
					<a class="title" href="{url page="issue" op="view" path=$issue->getBestIssueId($currentJournal)}">
						{$issue->getIssueIdentification()}
					</a>
				</div>


				{* Screen-reader heading for easier navigation jumps *}
				<h2 class="sr-only">{translate key="plugins.themes.academic_pro.article.main"}</h2>

				{if $article->getAuthors()}
					<div class="row authors">
						{foreach from=$article->getAuthors() item=author}
							<div class="author">
								<i class="fa fa-user"> </i>
								<strong>{$author->getFullName()|escape}</strong>
								{if $author->getLocalizedAffiliation()}
									<div class="article-author-affilitation">
										{$author->getLocalizedAffiliation()|escape}
									</div>
								{/if}
								{if $author->getOrcid()}
									<div class="orcid">
										<svg class="orcid_icon" viewBox="0 0 256 256" aria-hidden="true">
											<style type="text/css">
												{literal} 
													.st0{fill:#A6CE39;}
													.st1{fill:#FFFFFF;}
												{/literal} 
											</style>
											<path class="st0"
												d="M256,128c0,70.7-57.3,128-128,128C57.3,256,0,198.7,0,128C0,57.3,57.3,0,128,0C198.7,0,256,57.3,256,128z">
											</path>
											<g>
												<path class="st1" d="M86.3,186.2H70.9V79.1h15.4v48.4V186.2z"></path>
												<path class="st1" d="M108.9,79.1h41.6c39.6,0,57,28.3,57,53.6c0,27.5-21.5,53.6-56.8,53.6h-41.8V79.1z M124.3,172.4h24.5
													c34.9,0,42.9-26.5,42.9-39.7c0-21.5-13.7-39.7-43.7-39.7h-23.7V172.4z"></path>
												<path class="st1" d="M88.7,56.8c0,5.5-4.5,10.1-10.1,10.1c-5.6,0-10.1-4.6-10.1-10.1c0-5.6,4.5-10.1,10.1-10.1
													C84.2,46.7,88.7,51.3,88.7,56.8z"></path>
											</g>
										</svg>
										<a href="{$author->getOrcid()|escape}" target="_blank">
											{$author->getOrcid()|escape}
										</a>
									</div>
								{/if}
							</div>
							<div class="author-border"></div>
						{/foreach}
					</div>
				{/if}

				{* Article abstract *}
				{if $article->getLocalizedAbstract()}
					<div class="article-summary" id="summary">
						<h2>{translate key="article.abstract"}</h2>
						<div class="article-abstract">
							{$article->getLocalizedAbstract()|strip_unsafe_html|nl2br}
						</div>
					</div>
				{/if}

				{* Keywords *}
				{* @todo keywords not yet implemented *}



			</section><!-- .article-main -->

			<section class="article-more-details">

				{* Screen-reader heading for easier navigation jumps *}
				<h2 class="sr-only">{translate key="plugins.themes.academic_pro.article.details"}</h2>


				{* PubIds (requires plugins) *}
				{foreach from=$pubIdPlugins item=pubIdPlugin}
					{if $pubIdPlugin->getPubIdType() == 'doi'}
						{php}continue;{/php}
					{/if}
					{if $issue->getPublished()}
						{assign var=pubId value=$article->getStoredPubId($pubIdPlugin->getPubIdType())}
					{else}
						{assign var=pubId value=$pubIdPlugin->getPubId($article)}{* Preview pubId *}
					{/if}
					{if $pubId}
						<div class="panel panel-default pub_ids">
							<div class="panel-heading">
								{$pubIdPlugin->getPubIdDisplayType()|escape}
							</div>
							<div class="panel-body">
								{if $pubIdPlugin->getResolvingURL($currentJournal->getId(), $pubId)|escape}
									<a id="pub-id::{$pubIdPlugin->getPubIdType()|escape}"
										href="{$pubIdPlugin->getResolvingURL($currentJournal->getId(), $pubId)|escape}">
										{$pubIdPlugin->getResolvingURL($currentJournal->getId(), $pubId)|escape}
									</a>
								{else}
									{$pubId|escape}
								{/if}
							</div>
						</div>
					{/if}
				{/foreach}

				{* Article Subject *}
				{if $article->getLocalizedSubject()}
					<div class="panel panel-default subject">
						<div class="panel-heading">
							{translate key="article.subject"}
						</div>
						<div class="panel-body">
							{$article->getLocalizedSubject()|escape}
						</div>
					</div>
				{/if}




				{* Licensing info *}
				{if $copyright || $licenseUrl}
					<div class="panel panel-default copyright">
						<div class="panel-body">
							{if $licenseUrl}
								{if $ccLicenseBadge}
									{$ccLicenseBadge}
								{else}
									<a href="{$licenseUrl|escape}" class="copyright">
										{if $copyrightHolder}
											{translate key="submission.copyrightStatement" copyrightHolder=$copyrightHolder copyrightYear=$copyrightYear}
										{else}
											{translate key="submission.license"}
										{/if}
									</a>
								{/if}
							{/if}
							{$copyright}
						</div>
					</div>
				{/if}

				{* Author biographies *}
				{assign var="hasBiographies" value=0}
				{foreach from=$article->getAuthors() item=author}
					{if $author->getLocalizedBiography()}
						{assign var="hasBiographies" value=$hasBiographies+1}
					{/if}
				{/foreach}
				{if $hasBiographies}
					<div class="panel panel-default author-bios">
						<div class="panel-heading">

							{if $hasBiographies > 1}
								<i class="fa fa-users"> </i>{translate key="submission.authorBiographies"}
							{else}
								<i class="fa fa-user"> </i>{translate key="submission.authorBiography"}
							{/if}
						</div>
						<div class="panel-body">
							{foreach from=$article->getAuthors() item=author}
								{if $author->getLocalizedBiography()}
									<div class="media biography">
										<div class="media-body">
											<h3 class="media-heading biography-author">
												{if $author->getLocalizedAffiliation()}
													{capture assign="authorName"}{$author->getFullName()|escape}{/capture}
													{capture assign="authorAffiliation"}<span
														class="affiliation">{$author->getLocalizedAffiliation()|escape}</span>{/capture}
													{translate key="submission.authorWithAffiliation" name=$authorName affiliation=$authorAffiliation}
												{else}
													{$author->getFullName()|escape}
												{/if}
											</h3>
											{$author->getLocalizedBiography()|strip_unsafe_html}
										</div>
									</div>
								{/if}
							{/foreach}
						</div>
					</div>
				{/if}

				{* How to cite *}
				{if $citation}
					<div class="panel panel-default how-to-cite">
						<div class="panel-heading">
							<i class="fa fa-file-text"> </i> {translate key="submission.howToCite"}
						</div>
						<div class="panel-body">
							<div id="citationOutput" role="region" aria-live="polite">
								{$citation}
							</div>
							<div class="btn-group">
								<button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown"
									aria-controls="cslCitationFormats">
									{translate key="submission.howToCite.citationFormats"}
									<span class="caret"></span>
								</button>
								<ul class="dropdown-menu" role="menu">
									{foreach from=$citationStyles item="citationStyle"}
										<li>
											<a aria-controls="citationOutput"
												href="{url page="citationstylelanguage" op="get" path=$citationStyle.id params=$citationArgs}"
												data-load-citation
												data-json-href="{url page="citationstylelanguage" op="get" path=$citationStyle.id params=$citationArgsJson}">
												{$citationStyle.title|escape}
											</a>
										</li>
									{/foreach}
								</ul>
							</div>
						</div>
					</div>
				{/if}



				{call_hook name="Templates::Article::Details"}

				{* References *}
				{if $article->getCitations()}
					<div class="article-references">
						<h2><i class="fa fa-bookmark-o text-primary"> </i> {translate key="submission.citations"}</h2>
						<div class="article-references-content">
							{$article->getCitations()|nl2br}
						</div>
					</div>
				{/if}


			</section><!-- .article-details -->
		</div><!-- .col-md-8 -->
	</div><!-- .row -->

</article>