{**
 * templates/frontend/objects/announcement_summary.tpl
 *
  * Copyright (c) 2010-2020 openjournaltheme.com 
 * Copyright (c) 2010-2020 openjournaltheme team
 * Read this term of use of this theme here : https://openjournaltheme.com/term-of-conditions
 *
 * @brief Display a summary view of an announcement
 *
 * @uses $announcement Announcement The announcement to display
 *}
<article class="announcement-summary media">
	<div class="media-body">
		<h2 class="media-heading">
			<a href="{url router=$smarty.const.ROUTE_PAGE page="announcement" op="view" path=$announcement->getId()}">
				{$announcement->getLocalizedTitle()|escape}
			</a>
		</h2>
		<p class="date">
			<span class="glyphicon glyphicon-calendar"></span>
			{if ($journalVersion >= '33')}
				{$announcement->getDatePosted()|date_format:$dateFormatShort}
			{else}
				{$announcement->getDatePosted()|date_format}
			{/if}	
		</p>
		{$announcement->getLocalizedDescriptionShort()|strip_unsafe_html}
	</div>
</article><!-- .announcement-summary -->
