{**
 Academic Pro theme by openjournaltheme.com 
 author : Muhammad Hendra
 *
 * @brief Common frontend site header.
 *
 * @uses $isFullWidth bool Should this page be displayed without sidebars? This
 *       represents a page-level override, and doesn't indicate whether or not
 *       sidebars have been configured for thesite.
 * @uses $currentContext Journal|Press The current journal or press
 * @uses $author
 *}

{* Determine whether a logo or title string is being displayed *}
{assign var="showingLogo" value=true}
{if $displayPageHeaderTitle && !$displayPageHeaderLogo && is_string($displayPageHeaderTitle)}
	{assign var="showingLogo" value=false}
{/if}

<!DOCTYPE html>
<html lang="{$currentLocale|replace:"_":"-"}" xml:lang="{$currentLocale|replace:"_":"-"}">
{if !$pageTitleTranslated}{capture assign="pageTitleTranslated"}{translate key=$pageTitle}{/capture}{/if}
{include file="frontend/components/headerHead.tpl" description=$description  }


<body class="pkp_page_{$requestedPage|escape|default:"index"} pkp_op_{$requestedOp|escape|default:"index"}{if $showingLogo} has_site_logo{/if}">
	<div class="pkp_structure_page">

		<nav id="accessibility-nav" class="sr-only" role="navigation" aria-labelled-by="accessible-menu-label">
			<div id="accessible-menu-label">
				{translate|escape key="plugins.themes.academic_pro.accessible_menu.label"}
			</div>
			<ul>
			  <li><a href="#main-navigation">{translate|escape key="plugins.themes.academic_pro.accessible_menu.main_navigation"}</a></li>
			  <li><a href="#main-content">{translate|escape key="plugins.themes.academic_pro.accessible_menu.main_content"}</a></li>
			  <li><a href="#sidebar">{translate|escape key="plugins.themes.academic_pro.accessible_menu.sidebar"}</a></li>
			</ul>
		</nav>

		{* Header *}
		<header class="navbar navbar-default box-shadow background-white" id="headerNavigationContainer" role="banner">

			{* User profile, login, etc, navigation menu*}
			<div class="user_navigation">
			<div class="container">
				<div class="row">
				{* Mobile hamburger menu *}
					<button type="button" class="navbar-toggle collapsed pull-left" data-toggle="collapse" data-target="#nav-menu" aria-expanded="false" aria-controls="navbar">
						<span class="sr-only">Toggle navigation</span>
						<span class="icon-bar"></span>
						<span class="icon-bar"></span>
						<span class="icon-bar"></span>
					</button>
					<nav aria-label="{translate|escape key="common.navigation.user"}">
						{load_menu name="user" id="navigationUser" ulClass="nav nav-pills tab-list pull-right" linkClass="btn btn-info btn-sm"}
					</nav>
				</div><!-- .row -->
			</div><!-- .container-fluid -->
			</div>


			<div class="site_header">
			<div class="container">

				<div class="navbar-header">				

					{* Logo or site title. Only use <h1> heading on the homepage.
					   Otherwise that should go to the page title. *}
					{if $requestedOp == 'index'}
						<h1 class="site-name">
					{else}
						<div class="site-name">
					{/if}

					
						{capture assign="homeUrl"}
							{if $currentJournal && $multipleContexts}
								{url page="index" router=$smarty.const.ROUTE_PAGE}
							{else}
								{url context="index" router=$smarty.const.ROUTE_PAGE}
							{/if}
						{/capture}
					
						{if $displayPageHeaderTitle  && is_string($displayPageHeaderTitle)}
							<a href="{$homeUrl}" class="navbar-brand">{$displayPageHeaderTitle}</a>
						{elseif $displayPageHeaderTitle && is_array($displayPageHeaderTitle)}
							<a href="{$homeUrl}" class="navbar-brand navbar-brand-logo">
								<a href="{$homeUrl}" class="navbar-brand">{$displayPageHeaderTitle}</a>
							</a>
						{else}
							<a href="{$homeUrl}" class="navbar-brand">
								OJS Site Name
							</a>
						{/if}
					{if $requestedOp == 'index'}
						</h1>
					{else}
						</div>
					{/if}

				</div>

				{* Primary site navigation *}
				{capture assign="primaryMenu"}
					{load_menu name="primary" id="main-navigation" ulClass="nav navbar-nav"}
				{/capture}

				{if !empty(trim($primaryMenu)) || !$noContextsConfigured}
					<nav id="nav-menu" class="navbar-collapse collapse" aria-label="{translate|escape key="common.navigation.site"}">
						{* Primary navigation menu for current application *}
						{$primaryMenu}

						{* Search form *}
						{if !$noContextsConfigured}
							<div class="pull-md-right search_input">
								{include file="frontend/components/searchForm_simple.tpl"}
							</div>
						{/if}
					</nav>
				{/if}

			</div><!-- .pkp_head_wrapper -->

			</div>


			<div class="header_shadow"></div>


		</header><!-- .pkp_structure_head -->


		{if $requestedPage == 'index'}
		<div class="row journal_index">


			<div class="container">
				<div class="col-md-5 site_logo">
					
					{* Show site Logo *}
					{if $displayPageHeaderLogo && is_array($displayPageHeaderLogo)}
					<img style='width:100%; border="0"' src="{$publicFilesDir}/{$displayPageHeaderLogo.uploadName|escape:"url"}" {if $displayPageHeaderLogo.altText != ''}alt="{$displayPageHeaderLogo.altText|escape}"{else}alt="{translate key="common.pageHeaderLogo.altText"}"{/if}>
					{else}
						<img  style='width:100%; border="0"' alt="site_logo" src="{$pluginImageDir}top_logo.jpg" /> 
					{/if}
				</div>	
				
				{if $about}
				<div class="col-md-6 site_description">
							
								<div class="about_site">
									{$about|nl2br}
								</div>
						
				</div>	
				{/if}

			</div>	



			{if $currentContext }

				<div class="container">
					<div class="col-md-12 about_journal">
						<h1>About Journal </h1>
						<p>
						{$currentContext->getLocalizedSetting('about')}
						</p>
					</div>
				</div>



			{/if}

		</div>
		{else}
		{* end header for index *}



		{* begin header non index *}
		<div class="row non_index_header">
			<div class="container">

				{* specific article header *}
				{if $requestedPage == 'article'}

					{assign var=header_section_title_hidden value="hidden"}

					<div class="col-md-12 article-header">
					
						{if $section}
							{include file="frontend/components/breadcrumbs_article.tpl" currentTitle=$section->getLocalizedTitle()}
						{else}
							{include file="frontend/components/breadcrumbs_article.tpl" currentTitleKey="article.article"}
						{/if}


						<div class="col-md-12 no-padding header-section">
						
							{translate key="section.section"} {$section->getLocalizedTitle()|escape}
						
						</div>


						

							<div class="col-md-12 no-padding">
									<h1>{$article->getLocalizedTitle()|escape}</h1>
								{if $article->getLocalizedSubtitle()}
								<div class="subtitle">
									{$article->getLocalizedSubtitle()|escape}
										{if $section} <span class="pull-right"></span> {/if}
								</div>
								{/if}	
							
							</div>

							<div class="col-md-12 no-padding" style="margin-top: 10px">
								{if $article->getAuthors()}
								<div class="row authors">
									{foreach from=$article->getAuthors() item=author}
										{if $div == "first_col"}
											{assign var="div" value="second_col"}
										{else}
											{assign var="div" value="first_col"}
										{/if}
									

										<div class="author {$div}"  >
											<i class="fa fa-user"> </i>
												<strong>{$author->getFullName()|escape}</strong>
												{if $author->getLocalizedAffiliation()}
													<div class="article-author-affilitation">
														{$author->getLocalizedAffiliation()|escape}
													</div>
												{/if}
												{if $author->getOrcid()}
													<div class="orcid">
															<svg class="orcid_icon" viewBox="0 0 256 256" aria-hidden="true">
														<style type="text/css">
														{literal} 
															.st0{fill:#A6CE39;}
															.st1{fill:#FFFFFF;}
														{/literal} 
														</style>
														<path class="st0" d="M256,128c0,70.7-57.3,128-128,128C57.3,256,0,198.7,0,128C0,57.3,57.3,0,128,0C198.7,0,256,57.3,256,128z"></path>
														<g>
															<path class="st1" d="M86.3,186.2H70.9V79.1h15.4v48.4V186.2z"></path>
															<path class="st1" d="M108.9,79.1h41.6c39.6,0,57,28.3,57,53.6c0,27.5-21.5,53.6-56.8,53.6h-41.8V79.1z M124.3,172.4h24.5
																c34.9,0,42.9-26.5,42.9-39.7c0-21.5-13.7-39.7-43.7-39.7h-23.7V172.4z"></path>
															<path class="st1" d="M88.7,56.8c0,5.5-4.5,10.1-10.1,10.1c-5.6,0-10.1-4.6-10.1-10.1c0-5.6,4.5-10.1,10.1-10.1
																C84.2,46.7,88.7,51.3,88.7,56.8z"></path>
														</g>
													</svg>
														<a href="{$author->getOrcid()|escape}" target="_blank">
															{$author->getOrcid()|escape}
														</a>
													</div>
												{/if}
										</div>
										
									{/foreach}
								</div>
							{/if}
							
							</div>

						</div>
						{* end article header text *}
				
				
				{/if}
				{* end if article *}
				{assign var=page_request value=$requestedPage}

				{if $requestedPage == 'about'}
					{assign var=header_section value=$requestedOp}
					{if $requestedOp == 'index'}
							{assign var=header_section value='about'}
					{/if}
				{/if}


				{if $requestedPage == 'issue'}
					{assign var=header_section value=$requestedOp}
						{if $requestedOp == 'view'}
							{assign var=header_section value='Current Issue'}
						{/if}
				{/if}



				{if $requestedPage == 'search'}
					{assign var=header_section value='Search Result'}
				{/if}

			


				<div class="col-md-4 header-page-section {$header_section_title_hidden}">						
					{$header_section|escape}						
				</div>

				




			</div>

		</div>
		{* end header non index *}
		{/if}

		{* create custom variable if Full width *}	


		{* Wrapper for page content and sidebars *}
		<div class="pkp_structure_content container main_content">
			<main class="pkp_structure_main col-xs-12 col-sm-10 {if ($isFullWidth)} col-md-12 {else}  col-md-8 {/if} " role="main">
