{**
 * templates/frontend/components/headerHead.tpl
 *
 * Copyright (c) 2014-2018 Simon Fraser University
 * Copyright (c) 2000-2018 John Willinsky
 * Distributed under the GNU GPL v2. For full terms see the file docs/COPYING.
 *
 * Common site header <head> tag and contents.
 *}
{assign var=smarty_version value=$smarty.version|substr:0:1}
{* {$smarty_version} *}


<head>

	<meta http-equiv="Content-Type" content="text/html; charset={$defaultCharset|escape}">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>
		{$pageTitleTranslated|strip_tags}{* Add the journal name to the end of page titles *}{if $requestedPage|escape|default:"index" != 'index' && $currentContext && $currentContext->getLocalizedName()}
		| {$currentContext->getLocalizedName()}{/if}</title>
	<meta name="generator"
		content="{$pageTitleTranslated|strip_tags|escape|strip|replace:'	':''}{if $requestedPage|escape|default:"index" != 'index' && $currentContext && $currentContext->getLocalizedName()} | {$currentContext->getLocalizedName()}{/if}- {$activeTheme->getDisplayName()} by openjournaltheme.com">
	<meta name="robots" content="index follow">
	<meta name="googlebot" content="index follow">
	{* SEO *}
	{* Not index page *}
	{if $requestedOp != 'index' && $currentContext && $currentContext->getLocalizedName()}
		<meta name="description"
			content="{$description|strip_tags:false|regex_replace:"/(<|&(amp;)?lt;).*?(>|&(amp;)?gt;)/":""|replace:'&#039;':''}">
		<meta name="og:description"
			content="{$description|strip_tags:false|regex_replace:"/(<|&(amp;)?lt;).*?(>|&(amp;)?gt;)/":""|replace:'&#039;':''}">
		<meta name="author"
			content="{if $authorName}{$authorName}{elseif !isset($authorName)}{$currentContext->getLocalizedName()|trim}{/if}" />
		<meta name="copyright" content="{$currentContext->getLocalizedName()} - {$publisherName}" />
		{* article page *}
		{if $requestedPage == 'article'}
			<meta name="keywords"
				content="{if !empty($keywords[$currentLocale])}{foreach from=$keywords item=keyword}{foreach name=keywords from=$keyword item=keywordItem name=keyword}{$keywordItem|escape|trim}{if not $smarty.foreach.keyword.last},{/if}{/foreach}{/foreach}{/if}">
		{/if}
		{* Index Page *}
	{else $requestedOp == 'index'}
		<meta name="description" content="{$about|strip_tags:false}">
		<meta name="og:description" content="{$about|strip_tags:false}">
		<meta name="author" content="{$displayPageHeaderTitle}" />
		<meta name="copyright" content="{$displayPageHeaderTitle}" />
	{/if}
	{if $isMaintenance}
		<meta http-equiv="cache-control" content="max-age=0" />
		<meta http-equiv="cache-control" content="no-cache" />
		<meta http-equiv="expires" content="0" />
		<meta http-equiv="expires" content="Tue, 01 Jan 1980 1:00:00 GMT" />
		<meta http-equiv="pragma" content="no-cache" />
	{/if}


	{* enable google scholar plugin *}
	{load_header context="frontend"}
	{if $requestedPage == 'article'}
		{* Show Citation DOI *}
		{* make compatible with ojs version less than 3.1.2 *}
		{if  $smarty_version == 2}
			{include file="legacy/meta_citation_3.1.1.tpl"}
		{/if}

		{if  $smarty_version == 3}
			{* Enable / disable doi on every article -- only support ojs > 3.1.2*}
			{include file="legacy/meta_citation_3.1.2.tpl"}
		{/if}

	{/if}

	{load_stylesheet context="frontend"}




</head>